﻿<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'config.php';

// Verify database connection
if (!isset($conn) || $conn->connect_error) {
    die("Database connection failed: " . ($conn->connect_error ?? 'Unknown error'));
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Debug logging
    error_log("Starting evaluation save process");
    error_log("Session contents: " . print_r($_SESSION, true));
    error_log("POST contents: " . print_r($_POST, true));

    // Validate required session variables
    if (!isset($_SESSION['school_id'])) {
        $_SESSION['error'] = "يجب البدء من صفحة البيانات العامة أولاً";
        error_log("Redirecting to general.php - school_id not set in session");
        header("Location: general.php");
        exit;
    }

    // Use session school_id consistently
    $SchoolID = $_SESSION['school_id'];
    error_log("Using SchoolID from session: " . $SchoolID);

    try {
        // Validate all required fields are present
        $requiredFields = [
            'Q4_1', 'Q4_2',
            'Q27_ch1', 'Q28_ch1', 'Q29_ch1',
            'Q27_ch2', 'Q28_ch2', 'Q29_ch2',
            'Q27_ch3', 'Q28_ch3', 'Q29_ch3',
            'Q27_ch4', 'Q28_ch4', 'Q29_ch4'
        ];

        foreach ($requiredFields as $field) {
            if (!isset($_POST[$field])) {
                throw new Exception("حقل مطلوب مفقود: " . $field);
            }
        }

        // Get values from form with proper validation
        $techhaveQ = (int)$_POST['Q4_1'];
        $techsharing = (int)$_POST['Q4_2'];

        // Child data
        $Child1Persistance27_1 = (int)$_POST['Q27_ch1'];
        $Child1FollowInstructions28_1 = (int)$_POST['Q28_ch1'];
        $Child1Empathy29_1 = (int)$_POST['Q29_ch1'];
        
        $Child2Persistance27_2 = (int)$_POST['Q27_ch2'];
        $Child2FollowInstructions28_2 = (int)$_POST['Q28_ch2'];
        $Child2Empathy29_2 = (int)$_POST['Q29_ch2'];
        
        $Child3Persistance27_3 = (int)$_POST['Q27_ch3'];
        $Child3FollowInstructions28_3 = (int)$_POST['Q28_ch3'];
        $Child3Empathy29_3 = (int)$_POST['Q29_ch3'];
        
        $Child4Persistance27_4 = (int)$_POST['Q27_ch4'];
        $Child4FollowInstructions28_4 = (int)$_POST['Q28_ch4'];
        $Child4Empathy29_4 = (int)$_POST['Q29_ch4'];

        // Prepare SQL
        $sql = "INSERT INTO childrenevaluation_4 (
            SchoolID, techhaveQ, techsharing,
            Child1Persistance27_1, Child1FollowInstructions28_1, Child1Empathy29_1,
            Child2Persistance27_2, Child2FollowInstructions28_2, Child2Empathy29_2,
            Child3Persistance27_3, Child3FollowInstructions28_3, Child3Empathy29_3,
            Child4Persistance27_4, Child4FollowInstructions28_4, Child4Empathy29_4
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        error_log("Preparing SQL: " . $sql);

        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("Failed to prepare statement: " . $conn->error);
        }

        // Bind parameters
        $bindResult = $stmt->bind_param(
            "iiiiiiiiiiiiiii",
            $SchoolID,
            $techhaveQ,
            $techsharing,
            $Child1Persistance27_1,
            $Child1FollowInstructions28_1,
            $Child1Empathy29_1,
            $Child2Persistance27_2,
            $Child2FollowInstructions28_2,
            $Child2Empathy29_2,
            $Child3Persistance27_3,
            $Child3FollowInstructions28_3,
            $Child3Empathy29_3,
            $Child4Persistance27_4,
            $Child4FollowInstructions28_4,
            $Child4Empathy29_4
        );

        if (!$bindResult) {
            throw new Exception("Failed to bind parameters: " . $stmt->error);
        }

        if ($stmt->execute()) {
            $_SESSION['success'] = "تم حفظ بيانات التقييم بنجاح";
            error_log("Data saved successfully, redirecting to evaluation_5.php");
            header("Location: evaluation_5.php");
            exit;
        } else {
            throw new Exception("Failed to execute statement: " . $stmt->error);
        }
    } catch (Exception $e) {
        error_log("Exception: " . $e->getMessage());
        $_SESSION['error'] = "حدث خطأ أثناء حفظ البيانات: " . $e->getMessage();
        header("Location: evaluation.php");
        exit;
    }
} else {
    $_SESSION['error'] = "الطلب غير صالح";
    header("Location: evaluation.php");
    exit;
}