<?php
header('Content-Type: text/html; charset=utf-8');
session_start();
// include 'config.php'; // Uncomment if you have a config.php and it's not included elsewhere

// Ensure user_id is set, otherwise redirect to login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Determine SchoolID:
// 1. If SchoolID is explicitly passed via POST (e.g., from a selection form)
// 2. Else, use SchoolID from session if previously set
// 3. This $currentSchoolID will be used to set $_SESSION['school_id'] for save_teachers.php
$currentSchoolID = null;
if (isset($_POST['SchoolID'])) { 
    $currentSchoolID = $_POST['SchoolID'];
    $_SESSION['school_id'] = $currentSchoolID; // Set for save_teachers.php
    $_SESSION['SchoolID'] = $currentSchoolID; // Keep for consistency if other parts use it
} elseif (isset($_SESSION['SchoolID'])) { // Use existing session SchoolID if POST is not set
    $currentSchoolID = $_SESSION['SchoolID'];
    $_SESSION['school_id'] = $currentSchoolID; // Ensure school_id (lowercase) is also set
} elseif (isset($_SESSION['school_id'])) { // Fallback to school_id if SchoolID is not set
     $currentSchoolID = $_SESSION['school_id'];
     $_SESSION['SchoolID'] = $currentSchoolID; // Ensure SchoolID (uppercase) is also set
} else {
    // If no SchoolID is found, you might redirect or show an error,
    // or ensure it's set during login. For now, we'll allow it to be potentially empty
    // but save_teachers.php might fail if $_SESSION['school_id'] is not set there.
    // The save_teachers.php checks `if (!isset($_SESSION['school_id']))`
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مقابلة المعلمات - نظام متابعة جودة رياض الأطفال</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --accent-color: #f8b400;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
            --success-color: #4caf50; 
            --info-color: #00bcd4;
            --warning-color: #ff9800;
            --danger-color: #f44336;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .header h2 {
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .header p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 0;
        }
        
        .container {
            max-width: 1200px;
        }
        
        .nav-tabs {
            border-bottom: 2px solid #dee2e6;
            margin-bottom: 1.5rem;
        }
        
        .nav-tabs .nav-link {
            border: 1px solid #dee2e6;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            margin-left: 5px; 
            background: #f8f9fa;
            color: var(--dark-color);
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }
        
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            border-color: #dee2e6;
        }
        
        .nav-tabs .nav-link.active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }
        
        .tab-content {
            padding: 25px;
            border: 1px solid #dee2e6;
            border-top: none;
            background: white;
            border-radius: 0 0 5px 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }
        
        .section {
            margin-bottom: 30px;
            padding: 25px;
            background-color: white;
            border-radius: 8px;
            border-left: 5px solid var(--primary-color); 
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .section-title { 
            color: var(--primary-color);
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
            background: white;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        th, td {
            border: 1px solid #e0e0e0;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: var(--primary-color); 
            color: white;
            font-weight: 500;
        }
        
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tr:hover {
            background-color: #f1f1f1;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            font-weight: 500;
            color: var(--dark-color);
            margin-bottom: 8px;
            display: block;
        }
        
        .radio-group { 
            display: flex;
            gap: 20px;
            margin: 15px 0;
            flex-wrap: wrap;
        }

        .radio-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-weight: normal;
        }

        input[type="text"],
        input[type="number"],
        input[type="email"],
        input[type="password"],
        select,
        textarea {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        select:focus,
        textarea:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-custom-save { 
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: white;
            padding: 12px 30px;
            font-size: 18px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-custom-save:hover {
            background-color: #246b66;
            border-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
         .btn-custom-save:active {
            transform: translateY(0);
        }

        .welcome-message {
            background-color: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            border-left: 4px solid var(--accent-color); 
        }
        .welcome-message h3 {
            color: var(--dark-color);
            margin-bottom: 0;
            font-weight: 600;
        }

        .icon { 
            margin-left: 8px; 
        }

        @media (max-width: 992px) {
            .nav-tabs .nav-link { padding: 10px 15px; font-size: 14px; }
            .section { padding: 20px; }
            th, td { padding: 10px; font-size: 14px; }
        }
        
        @media (max-width: 768px) {
            .header { padding: 1.5rem 0; }
            .header h1 { font-size: 1.8rem; }
            .header h2 { font-size: 1.3rem; }
            .nav-tabs { flex-wrap: nowrap; overflow-x: auto; white-space: nowrap; -webkit-overflow-scrolling: touch; padding-bottom: 5px; }
            .nav-tabs .nav-link { padding: 8px 12px; font-size: 13px; }
            .tab-content { padding: 15px; }
            .section { padding: 15px; }
            table { display: block; overflow-x: auto; white-space: nowrap; }
            .radio-group { gap: 10px; }
        }
        
        @media (max-width: 576px) {
            .header h1 { font-size: 1.5rem; }
            .header h2 { font-size: 1.1rem; }
            .btn-custom-save { width: 100%; padding: 12px; }
            .radio-group { flex-direction: column; gap: 8px; }
        }
        .btn { 
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn-primary { 
            background-color: var(--primary-color);
            color: white;
            border: 1px solid var(--primary-color);
        }
        .btn-primary:hover {
            background-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            color: white;
        }
        .btn-secondary { 
             background-color: var(--light-color);
             color: var(--dark-color);
             border: 1px solid var(--primary-color); 
        }
        .btn-secondary:hover{
            background-color: #e9ecef;
        }
        .btn-lg {
            padding: 12px 30px;
            font-size: 1.1rem;
        }
        .nav-buttons { 
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

    </style>
</head>
<body>

    <div class="header text-center">
        <div class="container">
            <h1><i class="fas fa-child icon"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <h2><i class="fas fa-map-marker-alt icon"></i> في جمهورية مصر العربية</h2>
            <p><i class="fas fa-university icon"></i> المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
    </div>

    <div class="container py-3">
        <?php if (isset($_SESSION['fullname'])): ?>
        <div class="welcome-message">
            <h3><i class="fas fa-user-circle icon"></i> مرحبًا، <?php echo htmlspecialchars($_SESSION['fullname']); ?></h3>
        </div>
        <?php
// Display success/error messages
if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger">
        <?= $_SESSION['error']; unset($_SESSION['error']); ?>
    </div>
<?php endif; ?>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success">
        <?= $_SESSION['success']; unset($_SESSION['success']); ?>
    </div>
<?php endif; ?>
        <?php endif; ?>
        
        <ul class="nav nav-tabs" id="formTabs">
            <li class="nav-item">
                <a class="nav-link" href="general.php"> <i class="fas fa-info-circle"></i> البيانات العامة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="teachers.php"> 
                    <i class="fas fa-chalkboard-teacher"></i> مقابلة لمعلمات
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="activities.php">
                    <i class="fas fa-book-open"></i> أنشطة التعليم والتعلم
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="facilities.php"> 
                    <i class="fas fa-school"></i> مرافق الروضة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="evaluation.php">
                    <i class="fas fa-clipboard-check"></i> تقويم الأطفال من وجهة نظر المعلمات
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="evaluation_5.php"> <i class="fas fa-user-tie"></i> تقييم الأطفال من قبل القائم بالتطبيق
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="manual.php"> <i class="fas fa-book"></i> دليل المستخدم
                </a>
            </li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade show active" id="teachers-content">
                 <form action="save_teachers.php" method="POST">
                     <?php if ($currentSchoolID !== null): ?>
                        <input type="hidden" name="SchoolID_form" value="<?php echo htmlspecialchars($currentSchoolID); ?>">
                     <?php endif; ?>

                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-comments icon"></i> أولاً: نموذج موافقة المعلمات</h2>    
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th colspan="2">معلمة (1)</th>
                                        <th colspan="2">معلمة (2)</th>
                                    </tr>
                                    <tr>
                                        <td></td><td></td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>هل لديك أسئلة أخرى يمكن توضيحها؟</td>
                                        <td><input type="radio" name="Teacher1Q1" value="1" required></td> <td><input type="radio" name="Teacher1Q1" value="0" required></td> <td><input type="radio" name="Teacher2Q1" value="1" required></td>
                                        <td><input type="radio" name="Teacher2Q1" value="0" required></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>هل أنتِ مستعدة للمشاركة؟</td>
                                        <td><input type="radio" name="Teacher1Q2" value="1" required></td> <td><input type="radio" name="Teacher1Q2" value="0" required></td> <td><input type="radio" name="Teacher2Q2" value="1" required></td>
                                        <td><input type="radio" name="Teacher2Q2" value="0" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h3 class="section-title mt-4"><i class="fas fa-info-circle icon"></i> ثانياً: معلومات أساسية عن المعلمات</h3>

                        <h4><i class="fas fa-graduation-cap icon"></i> 3- ما أعلى مستوى تعليمي حصلت عليه؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. أقل من الليسانس/ البكالوريوس</td>
                                        <td><input type="radio" name="Teacher1EducationLevel3" value="1" required></td>
                                        <td><input type="radio" name="Teacher2EducationLevel3" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>2. الليسانس/البكالوريوس</td>
                                        <td><input type="radio" name="Teacher1EducationLevel3" value="2" required></td>
                                        <td><input type="radio" name="Teacher2EducationLevel3" value="2" required></td>
                                    </tr>
                                    <tr>
                                        <td>3. دبلوم دراسات عليا تربوي</td>
                                        <td><input type="radio" name="Teacher1EducationLevel3" value="3" required></td>
                                        <td><input type="radio" name="Teacher2EducationLevel3" value="3" required></td>
                                    </tr>
                                    <tr>
                                        <td>4. ماجستير</td>
                                        <td><input type="radio" name="Teacher1EducationLevel3" value="4" required></td>
                                        <td><input type="radio" name="Teacher2EducationLevel3" value="4" required></td>
                                    </tr>
                                    <tr>
                                        <td>5. دكتوراه</td>
                                        <td><input type="radio" name="Teacher1EducationLevel3" value="5" required></td>
                                        <td><input type="radio" name="Teacher2EducationLevel3" value="5" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4><i class="fas fa-book icon"></i> 4- إذا كنت حاصلة على درجة علمية فما تخصصك؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. لا ينطبق (غير حاصل على درجة علمية)</td>
                                        <td><input type="radio" name="Teacher1Specialization4" value="1" required></td>
                                        <td><input type="radio" name="Teacher2Specialization4" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>2. الطفولة المبكرة</td>
                                        <td><input type="radio" name="Teacher1Specialization4" value="2" required></td>
                                        <td><input type="radio" name="Teacher2Specialization4" value="2" required></td>
                                    </tr>
                                    <tr>
                                        <td>3. التعليم الأساسي</td>
                                        <td><input type="radio" name="Teacher1Specialization4" value="3" required></td>
                                        <td><input type="radio" name="Teacher2Specialization4" value="3" required></td>
                                    </tr>
                                    <tr>
                                        <td>4. آخر</td>
                                        <td><input type="radio" name="Teacher1Specialization4" value="4" required></td>
                                        <td><input type="radio" name="Teacher2Specialization4" value="4" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4><i class="fas fa-calendar-alt icon"></i> 5- متى بدأت التدريس لأول مرة؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. قبل عام 2000</td>
                                        <td><input type="radio" name="Teacher1Experience5" value="1" required></td>
                                        <td><input type="radio" name="Teacher2Experience5" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>2. بعد عام 2000</td>
                                        <td><input type="radio" name="Teacher1Experience5" value="2" required></td>
                                        <td><input type="radio" name="Teacher2Experience5" value="2" required></td>
                                    </tr>
                                    <tr>
                                        <td>3. لا أتذكر </td>
                                        <td><input type="radio" name="Teacher1Experience5" value="3" required></td>
                                        <td><input type="radio" name="Teacher2Experience5" value="3" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-chalkboard icon"></i> 6- هل حضرت أي تدريب أثناء الخدمة خلال السنة الماضية؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. لا </td>
                                        <td><input type="radio" name="Teacher1Training6" value="1" required></td>
                                        <td><input type="radio" name="Teacher2Training6" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>2. (4 أيام) أو أقل من التدريب/ ورش العمل </td>
                                        <td><input type="radio" name="Teacher1Training6" value="2" required></td>
                                        <td><input type="radio" name="Teacher2Training6" value="2" required></td>
                                    </tr>
                                    <tr>
                                        <td>3. (5 أيام) أو أكثر من التدريب/ ورش العمل</td>
                                        <td><input type="radio" name="Teacher1Training6" value="3" required></td>
                                        <td><input type="radio" name="Teacher2Training6" value="3" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-book-reader icon"></i> 7- إذا كانت إجابتك رقم 2 أو رقم 3 في السؤال السابق، فما الموضوعات الرئيسة لجلسة (جلسات) التدريب أثناء الخدمة؟</h4>
                        <div class="table-responsive" id="q7-section">
                             <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. منهج جديد لنظام التعليم الجديد الذي بدأ في 2018 في مرحلة الروضة </td>
                                        <td><input type="radio" name="Teacher1TrainingTopics7" value="1" ></td>
                                        <td><input type="radio" name="Teacher2TrainingTopics7" value="1" ></td>
                                    </tr>
                                    <tr>
                                        <td>2. برنامج المعلمون أولاً </td>
                                        <td><input type="radio" name="Teacher1TrainingTopics7" value="2" ></td>
                                        <td><input type="radio" name="Teacher2TrainingTopics7" value="2" ></td>
                                    </tr>
                                    <tr>
                                        <td>3. غيرها</td>
                                        <td><input type="radio" name="Teacher1TrainingTopics7" value="3" ></td>
                                        <td><input type="radio" name="Teacher2TrainingTopics7" value="3" ></td>
                                    </tr>
                                    <tr>
                                        <td>4. لا ينطبق (لم أحضر تدريب)</td>
                                        <td><input type="radio" name="Teacher1TrainingTopics7" value="0" ></td> <td><input type="radio" name="Teacher2TrainingTopics7" value="0" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="text-center mt-4 mb-5">
                         <button type="submit" class="btn btn-primary btn-lg btn-custom-save">
                             <i class="fas fa-save"></i> حفظ بيانات المعلمات
                         </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="nav-buttons">
            <button type="button" class="btn btn-secondary prev-tab-custom">
                <i class="fas fa-arrow-right"></i> السابق
            </button>
            <button type="button" class="btn btn-primary next-tab-custom">
                <i class="fas fa-arrow-left"></i> التالي
            </button>
        </div>

    </div>
      
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = Array.from(document.querySelectorAll('.nav-tabs .nav-link'));
            let currentTabIndex = tabs.findIndex(tab => tab.classList.contains('active'));

            const nextBtn = document.querySelector('.next-tab-custom');
            const prevBtn = document.querySelector('.prev-tab-custom');

            function updateButtonVisibility() {
                if (prevBtn) prevBtn.style.display = currentTabIndex === 0 ? 'none' : 'inline-flex';
                if (nextBtn) nextBtn.style.display = currentTabIndex === tabs.length - 1 ? 'none' : 'inline-flex';
            }

            if (nextBtn) {
                nextBtn.addEventListener('click', function() {
                    if (currentTabIndex < tabs.length - 1) {
                        const nextTabLink = tabs[currentTabIndex + 1];
                        if(nextTabLink && nextTabLink.href) window.location.href = nextTabLink.href;
                    }
                });
            }

            if (prevBtn) {
                prevBtn.addEventListener('click', function() {
                    if (currentTabIndex > 0) {
                       const prevTabLink = tabs[currentTabIndex - 1];
                       if(prevTabLink && prevTabLink.href) window.location.href = prevTabLink.href;
                    }
                });
            }
            
            updateButtonVisibility();

            const q6RadiosT1 = document.querySelectorAll('input[name="Teacher1Training6"]');
            const q7SetT1 = document.querySelectorAll('input[name="Teacher1TrainingTopics7"]');
            const q6RadiosT2 = document.querySelectorAll('input[name="Teacher2Training6"]');
            const q7SetT2 = document.querySelectorAll('input[name="Teacher2TrainingTopics7"]');

            function toggleQ7(q6Value, q7SetControls) {
                let enableQ7 = (q6Value === "2" || q6Value === "3");
                q7SetControls.forEach(radio => {
                    radio.disabled = !enableQ7;
                    if (!enableQ7) {
                        radio.checked = false; 
                        if (radio.value === "0") { // Auto-check "لا ينطبق"
                            radio.checked = true;
                        }
                    }
                });
            }

            

            const teachersForm = document.querySelector('form[action="save_teachers.php"]');
            if (teachersForm) {
                teachersForm.addEventListener('submit', function(e) {
                    let formIsValid = true;
                    
                    // Validate Q7 for Teacher 1
                    const t1q6SelectedNode = document.querySelector('input[name="Teacher1Training6"]:checked');
                    if (t1q6SelectedNode && (t1q6SelectedNode.value === "2" || t1q6SelectedNode.value === "3")) {
                        const t1q7SelectedNode = document.querySelector('input[name="Teacher1TrainingTopics7"]:checked');
                        if (!t1q7SelectedNode || t1q7SelectedNode.value === "0") { // If attended training but selected "لا ينطبق" for topics
                            // formIsValid = false; // Or handle as a soft warning
                        }
                    }

                    // Validate Q7 for Teacher 2
                    const t2q6SelectedNode = document.querySelector('input[name="Teacher2Training6"]:checked');
                    if (t2q6SelectedNode && (t2q6SelectedNode.value === "2" || t2q6SelectedNode.value === "3")) {
                        const t2q7SelectedNode = document.querySelector('input[name="Teacher2TrainingTopics7"]:checked');
                        if (!t2q7SelectedNode || t2q7SelectedNode.value === "0") {
                           // formIsValid = false;
                        }
                    }

                    if (!this.checkValidity() || !formIsValid) {
                        e.preventDefault();
                        e.stopPropagation();
                        this.classList.add('was-validated'); 
                        alert('يرجى ملء جميع الحقول المطلوبة بشكل صحيح والتأكد من اتساق الإجابات (مثلاً، إذا تم حضور تدريب، يجب تحديد نوع التدريب).');
                    } else {
                        const saveButton = this.querySelector('.btn-custom-save');
                        if (saveButton) {
                            saveButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري الحفظ...';
                            saveButton.disabled = true;
                        }
                    }
                });
            }
        });
    </script>

</body>
</html>